capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\DNSP - Previous Output Weights\Stata files\TFP Analysis\Index analysis"
set more off
log using Outputs/log/anDNSP25-dnsppooled-post2011, replace text
*set scheme vg_s1c

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Benchmarking AER - Previous Output Weights
Author:  Michael Cunningham
File:    anDNSP25-dnsppooled-post2011.do
Initial Date:    25-Jun-2022
Revised Date:	  8-Oct-2025
--------------------------------------------------------------------------*/

scalar define rss1     = 0.0858
scalar define rss2     = 0.3376
scalar define rss3     = 0.1852
scalar define rss4     = 0.3914

local outputs energy ratchetmd customers circlength cmos
local inputs ropex overheadst overheadd undergrst undergrd transform
local costs opex auc_overheadst	auc_overheadd auc_undergrst auc_undergrd ///
	auc_transform
	

* Read dataset & create variables

use Inputs/dta/dnspbench25-firm, clear
sort dnsp year
drop if year < 2012

describe, fullnames
summarize
gen ropex = opex / price_opex

gen byte firstob = 1
replace firstob = 0 if firstob[_n-1] != .

* output and input quantities

local j = 1
foreach i of local outputs {
	gen q`j' = `i'
	local ++j
}

local j = 1
foreach i of local inputs {
	gen x`j' = `i'
	local ++j
}

* Input costs and cost shares

local j = 1
foreach i of local costs {
	gen c`j' = `i'
	local ++j
}
gen tc = c1 + c2 + c3 + c4 + c5 + c6

forvalues i = 1/6 {
	gen cs`i' = c`i' / tc
	gen w`i' = c`i' / x`i'
	gen lx`i' = log(x`i')
}

* Capital inputs only

gen kc = c2 + c3 + c4 + c5 + c6
forvalues i = 2/6 {
	gen ks`i' = c`i' / kc
}

* Output values and value shares

gen gr = revenue + price_cmos*cmos/1000
gen v5 = - price_cmos*cmos/1000
forvalues i = 1/4 {
	gen v`i' = rss`i'*gr
}

forvalues i = 1/5 {
	gen vs`i' = v`i'/ revenue
	gen p`i' = v`i'/ q`i'
	gen lq`i' = log(q`i')
}

*gen rshrtest = (r1 + r2 + r3 + r4 + r5) / revenue
*summarize rshrtest
*drop rshrtest

* Means & Lags

forvalues j = 1/6 {
	summarize lx`j', meanonly 
	scalar define lx`j'_m = r(mean)
	summarize cs`j', meanonly 
	scalar define cs`j'_m = r(mean)	
	gen lx`j'_l = lx`j'[_n-1]
	gen cs`j'_l = cs`j'[_n-1]	
}

forvalues j = 1/5 {
	summarize lq`j', meanonly 
	scalar define lq`j'_m = r(mean)
	summarize vs`j', meanonly 
	scalar define vs`j'_m = r(mean)	
	gen lq`j'_l = lq`j'[_n-1]
	gen vs`j'_l = vs`j'[_n-1]	
}


forvalues j = 2/6 {
	summarize ks`j', meanonly 
	scalar define ks`j'_m = r(mean)	
	gen ks`j'_l = ks`j'[_n-1]	
}


scalar list
describe


* Output Index

foreach k of numlist 1/5 {
	gen outdelta`k' = (vs`k' + vs`k'_m)*(lq`k' - lq`k'_m)/2 ///
			      - (vs`k'_l + vs`k'_m)*(lq`k'_l - lq`k'_m)/2
}
gen outdelta = outdelta1 + outdelta2 + outdelta3 + outdelta4 + outdelta5
gen outx = 1
replace outx = outx[_n-1] * exp(outdelta) if firstob == 0 

* Input Index

foreach k of numlist 1/6 {
	gen indelta`k' = (cs`k' + cs`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (cs`k'_l + cs`k'_m)*(lx`k'_l - lx`k'_m)/2
}
gen indelta = indelta1 + indelta2 + indelta3 + indelta4 + indelta5 + indelta6
gen inx = 1
replace inx = inx[_n-1] * exp(indelta) if firstob == 0 


* TFP Index

gen tfpdelta = outdelta - indelta
gen tfpx = 1
replace tfpx = tfpx[_n-1] * exp(tfpdelta) if firstob == 0 

* Opex PFP Index

gen odelta = lx1 - lx1_l
gen opinx = 1
replace opinx = opinx[_n-1] * exp(odelta) if firstob == 0
gen opfpdelta = outdelta - odelta
gen opfpx = 1
replace opfpx = opfpx[_n-1] * exp(opfpdelta) if firstob == 0 

* Capital Index

foreach k of numlist 2/6 {
	gen kdelta`k' = (ks`k' + ks`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (ks`k'_l + ks`k'_m)*(lx`k'_l - lx`k'_m)/2
}
gen kdelta = kdelta2 + kdelta3 + kdelta4 + kdelta5 + kdelta6
gen kinx = 1
replace kinx = kinx[_n-1] * exp(kdelta) if firstob == 0 

* Capital PFP Index

gen kpfpdelta = outdelta - kdelta
gen kpfpx = 1
replace kpfpx = kpfpx[_n-1] * exp(kpfpdelta) if firstob == 0



* Write results file

export excel dnsp year outx inx tfpx opinx kinx opfpx kpfpx tfpdelta ///
	outdelta indelta outdelta1 outdelta2 outdelta3 outdelta4 outdelta5 ///
	indelta1 indelta2 indelta3 indelta4 indelta5 indelta6 odelta kdelta  ///
	using Outputs/xlsx/mtfp_dnsppooled.xlsx, sheet("post2011sample", replace) firstrow(var)
log close
exit
